/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterHtml                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <ctime>

#include "Gfitter/GResultWriterHtml.h"
#include "Gfitter/GParameter.h"
#include "Gfitter/GFitterBase.h"
#include "Gfitter/GResultBase.h"

using namespace std;

Gfitter::GResultWriterHtml::GResultWriterHtml( const TString& resultFileName )
   : GResultWriterBase( resultFileName )
{
   InitClassName( "GResultWriterHtml" );
}

Gfitter::GResultWriterHtml::~GResultWriterHtml()
{}

Bool_t Gfitter::GResultWriterHtml::Initialise()
{
   m_resultFile << "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">" << endl;
   m_resultFile << "<html>" << endl;
   m_resultFile << "<body text=\"#000000\" bgcolor=\"#FFFFFF\">" << endl;

   const time_t curr=time(0);	
   m_resultFile << "Date: " << ctime(&curr) << " <br><p>" << endl;
   return kTRUE;
}

Bool_t Gfitter::GResultWriterHtml::AddResults( const TString& action )
{
   // write the table of results 
   m_resultFile << "<font size=+1> <p><br><b>Results of " << action << ": </b><br><p></font>" << endl;
   m_resultFile << "<table border=1>" << endl;
   m_resultFile << " <thead>" << endl;
   m_resultFile << "  <tr>" << endl;
   m_resultFile << "   <th scope=col rowspan=2>ParameterName</th>" << endl;
   m_resultFile << "   <th scope=col rowspan=2>Value</th>" << endl;
   m_resultFile << "   <th scope=colgroup colspan=3>Uncertainties</th>" << endl;
   m_resultFile << "   <th scope=col rowspan=2>Glob. Corr.</th>" << endl;
   m_resultFile << "   <th scope=col rowspan=2> &Delta;&chi;<sup>2</sup><sub>min</sub></th>" << endl;
   m_resultFile << "  </tr>" << endl;
   m_resultFile << "  <tr>" << endl;
   m_resultFile << "   <th scope=col>+/-1&sigma; (sym.)</th>" << endl;
   m_resultFile << "   <th scope=col>+1&sigma;</th>" << endl;
   m_resultFile << "   <th scope=col>-1&sigma;</th>" << endl;
   m_resultFile << "  </tr>" << endl;
   m_resultFile << " </thead>" << endl;
	
   const GParPtrVec_t& fp = gStore()->GetActiveParameters();	
   for (GParPtrVec_t::const_iterator par = fp.begin(); par != fp.end(); par++) {

      // print the result for those parameters which have a result
      if ((*par)->GetResult()) {
         m_resultFile << "<tr>" << endl;
         m_resultFile << "  <td> " << (*par)->GetParName() << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetValue() << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetErrGaussSym(1) << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetErrGaussAsym(1) << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetErrGaussAsym(-1) << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetGlobCorr() << " </td>" << endl;
         m_resultFile << "  <td> " << (*par)->GetResult()->GetChi2Min() << " </td>" << endl;
         m_resultFile << "</tr>" << endl;

      }
   }    
   m_resultFile << "</table>" << endl;  
   m_resultFile << endl;  
	
   return kTRUE;
}

Bool_t Gfitter::GResultWriterHtml::Finalise()
{
   m_resultFile << "</body>" << endl;
   m_resultFile << "</html>" << endl;
	
   m_resultFile.flush();
   m_resultFile.close(); 	

   return kTRUE;
}
