/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDCardInterpreterXML                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      HTML implementation of the ResultWriter                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultWriterHtml
#define Gfitter_GResultWriterHtml

#include "Gfitter/GResultWriterBase.h"

namespace Gfitter {

   class GResultWriterHtml : public GResultWriterBase {

   public:

      GResultWriterHtml( const TString& htmlFileName );
      ~GResultWriterHtml();

		Bool_t Initialise();      
      Bool_t AddResults( const TString& );
		Bool_t Finalise();      

   private:

   };
}

#endif
