/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterLatex                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Latex implementation of ResultWriter                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultWriterLatex
#define Gfitter_GResultWriterLatex

#include "Gfitter/GResultWriterBase.h"

namespace Gfitter {

   class GResultWriterLatex : public GResultWriterBase {

   public:

      GResultWriterLatex( const TString& texFileName );
      ~GResultWriterLatex();

		Bool_t Initialise();      
      Bool_t AddResults( const TString& );
		Bool_t Finalise();      

   private:

   };
}

#endif
