/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GScalerLinear                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Linear parameter scaler                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GScalerLinear
#define Gfitter_GScalerLinear

#include "GScalerBase.h"

class TString;
class TFormula;

namespace Gfitter {

   class GParameter;
   class GData;

   class GScalerLinear : public GScalerBase {

   public:

      GScalerLinear( const TString& parName, Double_t errp, Double_t errm, Int_t sign );
      GScalerLinear( const TString& expression );
      GScalerLinear( const GScalerLinear& );  
      virtual ~GScalerLinear();

      // rescaled central value
      Double_t GetBias();

      // accessors

   private:

   };
}

#endif
