/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GStringList                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      List of strings obtained from tokenlist                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GStringList
#define Gfitter_GStringList

#include <vector>

#include "Gfitter/GMsgLogger.h"

class TString;

namespace Gfitter {

   class GStringList {
      
   public:
      
      GStringList( const TString& argstr, const TString& separator = ":" );
      GStringList( std::vector<TString>& args );
      ~GStringList();
      
      std::vector<TString>& GetArgs()   const { return m_args; }
      const TString         GetArgStr() const;
      const TString&        GetArg( Int_t iarg ) const;   
      Bool_t                Contains( const TString& str )  const;
      Int_t                 GetEntries() const { return (Int_t)m_args.size(); }
      const TString&        operator[]( Int_t iarg ) const { return GetArg( iarg ); }
      
   private:

      std::vector<TString>& m_args;
      const TString&        m_separator;
      
      Bool_t                HasReplaced() const { return m_hasReplaced; }
      Bool_t                m_hasReplaced;

      mutable GMsgLogger    m_logger;

      // pattern used to replace protected patterns (such as "::")
      // variable names must not contain this patter initially
      static const TString  m_replacePattern; 
   };
}

#endif
