/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Namespace: GUtils                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Namespace for global utility functions                                    *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GUtils
#define Gfitter_GUtils

#include "TROOT.h"

#include "Gfitter/GStore.h"
#include "Gfitter/GMsgLogger.h"

class TList;
class TString;
class TH1;
class TH2;

namespace Gfitter {

   namespace GUtils {

      // function returns minimum chi2
      Float_t CreateProbTHist( TH1& chi2In, TH1& dchi2Out, TH1& dlikeOut, TH1& clOut );
      Float_t CreateProbTHist( TH2& chi2In, TH2& dchi2Out, TH2& dlikeOut, TH2& clOut );

      void    PrintParVector( GMsgLogger&, const GParPtrVec_t& v, TString vecName );

      // routines for formatted output -----------------
      void    FormattedOutput( const std::vector<Double_t>&, const std::vector<TString>&, 
                               const TString titleVars, const TString titleValues, 
                               GMsgLogger& logger, TString format = "%+1.3f" );
      void    FormattedOutput( const TMatrixD&, const std::vector<TString>&,
                               GMsgLogger& logger, const TString& format = "%+1.3f" );
      void    FormattedOutput( const TMatrixD&, const GParPtrVec_t&, 
                               GMsgLogger& logger, const TString& format = "%+1.3f", Bool_t printFullName = kTRUE );

      // string operations -----------------------------

      // remove namespace from beginning of string
      TString RemoveNamespace( const TString& inString );

      // v is cut into v1 and v2 at v[icut]
      void CutStringInParts( const TString& in, Int_t at, TString& v1, TString& v2 );      

      // routines for string interpretation ------------
      void InterpretErrorString       ( const TString& instr, Double_t& errp, Double_t& errm, GMsgLogger& );
      void InterpretValueErrorString  ( const TString& instr, Double_t& val, Double_t& errp, Double_t& errm, 
                                        GMsgLogger& );
      void InterpretValueErrorsString ( const TString& instr, Double_t& val, 
                                        std::vector<Double_t>& estatp, std::vector<Double_t>& estatm, 
                                        std::vector<Double_t>& esystp, std::vector<Double_t>& esystm, 
                                        std::vector<Double_t>& etheop, std::vector<Double_t>& ehteom, 
                                        GMsgLogger& );

      // expects format: "par = value", where value can be float or int or string
      // method returns "value"
      TString ExtractValueFromParSetting( const TString& str, GMsgLogger& ); 

      TString ReplaceRegularExpressions( const TString& s, const TString& r );

   }

   double ground(double x, unsigned int digits);

}

#endif
