/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GVariable                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Container for variables                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GVariable
#define Gfitter_GVariable

#include "Gfitter/GObject.h"
#include "TString.h"

namespace Gfitter {

   class GVariable;

   std::ostream& operator << ( std::ostream& os, const GVariable& variable );

   class GVariable : public GObject {

   public:

      enum Type { Bool, Int, Float, String };

      GVariable( const TString& name, const TString& value );
      ~GVariable();

      // type of variable
      Type           GetType() const { return m_type; }      
      const TString& GetVariableName() const { return m_name; }      

      // retrieve value of variables
      Bool_t         GetBoolValue()   const;
      Int_t          GetIntValue()    const;
      Float_t        GetFloatValue()  const;
      const TString& GetStringValue() const;

      const TString& GetValue() const { return m_value; }
    
   private:

      Type          m_type;
      const TString m_name; 
      const TString m_value; 

      Bool_t        m_b; 
      Int_t         m_i; 
      Float_t       m_f; 
      TString       m_s;
   };
}

#endif
